
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_NFE_REINSERIR_PENDENCIA_EMISSAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_NFE_REINSERIR_PENDENCIA_EMISSAO]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[P_NFE_REINSERIR_PENDENCIA_EMISSAO] (@TIPO CHAR(1), @CD_EMP INT, @CD_FILIAL INT, @NF_NF INT, @CD_NF INT = 0)
AS
BEGIN

	/*INSERIR UMA NOTA NA PENDENCIA DE EMISSO DE NFE*/
	IF (@TIPO <> 'S') AND (@TIPO <> 'E')
	BEGIN
		RAISERROR('TIPO DE NOTA NO RECONHECIDO!',16,1);
	END
	IF @TIPO = 'S' /*   S A I D A   */
	BEGIN
		IF @CD_NF = 0
		BEGIN
			SET @CD_NF = ISNULL((
							SELECT TOP 1 CD_NF FROM EST_NF_SAI NF
							INNER JOIN EST_NF_SERIE SERIE ON
										NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
									AND (SERIE.ESPC = 'NFE' OR SERIE.TP_SR_NFE = 1)
							WHERE NF.CD_EMP = @CD_EMP AND NF.CD_FILIAL = @CD_FILIAL AND NF.NF_NF = @NF_NF
							ORDER BY DT_EMI_NF DESC
						), 0);
		END
		ELSE
		BEGIN
			/*VERIFICAR SE O CODIGO NOTA INFORMADO EXISTE REALMENTE*/
			SET @CD_NF = ISNULL((
							SELECT TOP 1 CD_NF FROM EST_NF_SAI NF
							INNER JOIN EST_NF_SERIE SERIE ON
										NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
									AND (SERIE.ESPC = 'NFE' OR SERIE.TP_SR_NFE = 1)
							WHERE NF.CD_EMP = @CD_EMP AND NF.CD_FILIAL = @CD_FILIAL AND NF.CD_NF = @CD_NF
							ORDER BY DT_EMI_NF DESC
						), 0)		
		END
		IF @CD_NF > 0
		BEGIN
			--SELECT * FROM EST_NF_SAI WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_NF = @CD_NF;
			IF NOT EXISTS (SELECT 1 FROM EST_NF_SAI_NFE_PEND WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_NF = @CD_NF)
			BEGIN
				INSERT INTO EST_NF_SAI_NFE_PEND (CD_EMP, CD_FILIAL, CD_NF, PEND_SOLUC, DT_CAD) VALUES 
					(@CD_EMP, @CD_FILIAL, @CD_NF, 0, CONVERT(CHAR(10), GETDATE(), 108));
				PRINT 'NOTA INSERIDA NA PENDENCIA!';
			END
			ELSE
			BEGIN
				UPDATE EST_NF_SAI_NFE_PEND SET PEND_SOLUC = 0 
				WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_NF = @CD_NF
				PRINT 'NOTA ATUALIZADA NA PENDENCIA!';
			END
		END
		ELSE
		BEGIN
			RAISERROR('CODIGO DA NOTA DE SAIDA NO LOCALIZADO!',16,1);
		END
	END
	ELSE 
	IF @TIPO = 'E' /*   E N T R A D A   */
	BEGIN
		IF @CD_NF = 0
		BEGIN
			SET @CD_NF = ISNULL((
							SELECT TOP 1 CD_NF FROM EST_NF_ENT NF INNER JOIN EST_NF_ENT_EF_NF_CTR_NF ON
							NF.CD_EMP = EST_NF_ENT_EF_NF_CTR_NF.CD_EMP AND
							NF.CD_FILIAL = EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL AND
							NF.CD_NF = EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT
							INNER JOIN EST_NF_SERIE SERIE ON
										NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
									AND (SERIE.ESPC = 'NFE' OR SERIE.TP_SR_NFE = 1)
							WHERE NF.CD_EMP = @CD_EMP AND NF.CD_FILIAL = @CD_FILIAL AND NF.NR_NF = @NF_NF
							ORDER BY DT_ENT DESC
						), 0);
		END
		ELSE
		BEGIN
			/*VERIFICAR SE O CODIGO NOTA INFORMADO EXISTE REALMENTE*/
			SET @CD_NF = ISNULL((
							SELECT TOP 1 CD_NF FROM EST_NF_ENT NF INNER JOIN EST_NF_ENT_EF_NF_CTR_NF ON
							NF.CD_EMP = EST_NF_ENT_EF_NF_CTR_NF.CD_EMP AND
							NF.CD_FILIAL = EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL AND
							NF.CD_NF = EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT							
							INNER JOIN EST_NF_SERIE SERIE ON
										NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
									AND (SERIE.ESPC = 'NFE' OR SERIE.TP_SR_NFE = 1)
							WHERE NF.CD_EMP = @CD_EMP AND NF.CD_FILIAL = @CD_FILIAL AND NF.CD_NF = @CD_NF
							ORDER BY DT_ENT DESC
						), 0)		
		END
		IF @CD_NF > 0
		BEGIN
			--SELECT * FROM EST_NF_ENT WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_NF = @CD_NF;
			IF NOT EXISTS (SELECT 1 FROM EST_NF_ENT_NFE_PEND WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_NF = @CD_NF)
			BEGIN
				INSERT INTO EST_NF_ENT_NFE_PEND (CD_EMP, CD_FILIAL, CD_NF, PEND_SOLUC, DT_CAD) VALUES 
					(@CD_EMP, @CD_FILIAL, @CD_NF, 0, CONVERT(CHAR(10), GETDATE(), 108));
				PRINT 'NOTA INSERIDA NA PENDENCIA!';
			END
			ELSE
			BEGIN
				UPDATE EST_NF_ENT_NFE_PEND SET PEND_SOLUC = 0 
				WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_NF = @CD_NF
				PRINT 'NOTA ATUALIZADA NA PENDENCIA!';
			END
		END
		ELSE
		BEGIN
			RAISERROR('CODIGO DA NOTA DE ENTRADA NO LOCALIZADO!',16,1);
		END
	END
END